using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;

namespace VIRP.CRS.BLL
{
	public static partial class REFERRALManager
	{
        #region Fields
        #endregion

        #region Constructors
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static REFERRAL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static REFERRAL GetItemByPatientIcn(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string patientIcn)
        {
            REFERRAL objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, patientIcn);

            return objReturn;
        }

        public static List<REFERRAL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRAL> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<REFERRAL_LIST> GetListItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string STATUSCODE, string LASTNAME, string ORDERBY, string SORTORDER)
        {
            List<REFERRAL_LIST> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetListItems(CURRENT_USER, CURRENT_REGISTRY_ID, STATUSCODE, LASTNAME, ORDERBY, SORTORDER);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objSave)
        {
            Int32 objReturn = 0;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Int32 SaveHealthFactors(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int REFERRAL_ID, string HFIDS, string EFP_COMMENT, string BET_COMMENT, string AI_COMMENT, string SCI_COMMENT)
        {
            Int32 objReturn = 0;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.SaveHealthFactors(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, HFIDS, EFP_COMMENT, BET_COMMENT, AI_COMMENT, SCI_COMMENT);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            Boolean objReturn = false;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.REFERRAL_ID);
        }

        public static REFERRAL GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemComplete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static List<REFERRAL> GetItemsByRegistryStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_REFERRALSTS_ID)
        {
            List<REFERRAL> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemsByRegistryStatus(CURRENT_USER, CURRENT_REGISTRY_ID, STD_REFERRALSTS_ID);

            return objReturn;
        }

        //public static int GetItemsCommonByRegistryCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT)
        //{
        //    int objReturn = 0;
        //    REFERRALDB objDB = new REFERRALDB();

        //    objReturn = objDB.GetItemsCommonByRegistryCount(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT);

        //    return objReturn;
        //}

        //public static List<REFERRALcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        //{
        //    List<REFERRALcommon> objReturn = null;
        //    REFERRALDB objDB = new REFERRALDB();

        //    objReturn = objDB.GetItemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS);

        //    return objReturn;
        //}

        public static REFERRALcommonGroup GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS, bool IsPatientList)
        {
            List<REFERRALcommon> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();
            int completeCount = 0;

            objReturn = objDB.GetItemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID);

            if (PATIENT_ID > 0)
            {
                objReturn = objReturn.Where(x => x.PATIENT_ID == PATIENT_ID).ToList();
            }
            if (objReturn != null)
            {
                if (IsPatientList)
                    objReturn = objReturn.GroupBy(r => r.PATIENT_ID).Select(g => g.FirstOrDefault()).ToList();

                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                if (objReturn.Any(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)) != null))
                                {
                                    objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                                }
                                else
                                {
                                    objReturn = new List<REFERRALcommon>();
                                }
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                            }
                        }
                    }
                }

                //For performance, only return displayed records
                completeCount = objReturn.Count();
                objReturn = objReturn.Skip(START_ROW).Take(MAX_ROWS).ToList();
            }

            return new REFERRALcommonGroup()
            {
                ReferralCommon = objReturn,
                CompleteCount = completeCount
            };
        }

        public static List<REFERRALcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRALcommon> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            //objReturn = objDB.GetItemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, string.Empty, string.Empty, string.Empty, 0, 0);
            objReturn = objDB.GetItemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<REFERRALcommon> GetItemsCommonByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            List<REFERRALcommon> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemsCommonByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            return objReturn;
        }

        public static List<REFERRALcommon> GetItemsCommonByProvider(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PROVIDER_ID)
        {
            List<REFERRALcommon> objReturn = null;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.GetItemsCommonByProvider(CURRENT_USER, CURRENT_REGISTRY_ID, PROVIDER_ID);

            return objReturn;
        }

        public static Boolean CheckPatientExists(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            Boolean objReturn = false;
            REFERRALDB objDB = new REFERRALDB();

            REFERRAL objTemp = objDB.GetItemByRegistryPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
            if (objTemp != null)
                objReturn = true;

            return objReturn;
        }

        public static Int32 SaveManual(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, Int32 PROVIDER_ID)
        {
            Int32 objReturn = 0;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.SaveManual(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, PROVIDER_ID);

            return objReturn;
        }

        public static Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, Int32 STD_REFERRALSTS_ID)
        {
            Boolean objReturn = false;
            REFERRALDB objDB = new REFERRALDB();

            objReturn = objDB.UpdateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, STD_REFERRALSTS_ID);

            return objReturn;
        }

		#endregion
	}
}
